import React from "react";
import { useLanguage } from "@/contexts/LanguageContext";
import { SystemAnalysisData } from "@/types/analysis";

interface DepartmentsTabProps {
  systemData: SystemAnalysisData;
}

export default function DepartmentsTab({ systemData }: DepartmentsTabProps) {
  const { t } = useLanguage();
  return (
    <>
      {/* Department Analysis */}
      <div className='bg-white rounded-lg shadow mb-8'>
        <div className='px-6 py-4 border-b border-gray-200'>
          <h2 className='text-lg font-semibold'>
            {t("analysis.departmentAnalysis") || "Department Analysis"}
          </h2>
        </div>
        <div className='overflow-x-auto'>
          <table className='min-w-full divide-y divide-gray-200'>
            <thead className='bg-gray-50'>
              <tr>
                <th className='px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider'>
                  {t("admin.departments") || "Department"}
                </th>
                <th className='px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider'>
                  {t("analysis.ticketCount") || "Ticket Count"}
                </th>
                <th className='px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider'>
                  {t("analysis.avgSeverity") || "Avg Severity"}
                </th>
                <th className='px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider'>
                  {t("analysis.avgResolutionTime") || "Avg Resolution Time"}
                </th>
                <th className='px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider'>
                  {t("analysis.duplicates") || "Duplicates"}
                </th>
                <th className='px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider'>
                  {t("analysis.duplicatePercentage") || "Duplicate %"}
                </th>
              </tr>
            </thead>
            <tbody className='bg-white divide-y divide-gray-200'>
              {systemData.departmentStats.map((dept) => (
                <tr key={dept.department}>
                  <td className='px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900'>
                    {dept.department}
                  </td>
                  <td className='px-6 py-4 whitespace-nowrap text-sm text-gray-500'>
                    {dept.ticketCount}
                  </td>
                  <td className='px-6 py-4 whitespace-nowrap text-sm text-gray-500'>
                    {dept.avgSeverity.toFixed(1)}
                  </td>
                  <td className='px-6 py-4 whitespace-nowrap text-sm text-gray-500'>
                    {dept.avgResolutionTime.toFixed(1)}h
                  </td>
                  <td className='px-6 py-4 whitespace-nowrap text-sm text-gray-500'>
                    <span
                      className={
                        dept.duplicateCount > 0
                          ? "font-semibold text-orange-600"
                          : "text-gray-500"
                      }
                    >
                      {dept.duplicateCount}
                    </span>
                  </td>
                  <td className='px-6 py-4 whitespace-nowrap text-sm'>
                    <span
                      className={
                        dept.duplicatePercentage > 10
                          ? "font-semibold text-red-600"
                          : dept.duplicatePercentage > 5
                          ? "font-semibold text-orange-600"
                          : "text-gray-500"
                      }
                    >
                      {dept.duplicatePercentage.toFixed(1)}%
                    </span>
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      </div>
    </>
  );
}
